/*
 * Decompiled with CFR 0.152.
 */
package com.winternode.forge.wrapper;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class Wrapper {
    protected static final String FORGE_LIBRARIES_PATH = "libraries/net/minecraftforge/forge";
    protected static final String NEOFORGE_LIBRARIES_PATH = "libraries/net/neoforged/forge";
    protected static final String NEOFORGE_NEW_LIBRARIES_PATH = "libraries/net/neoforged/neoforge";
    protected static final String UNIX_ARGS_FILE = "unix_args.txt";
    protected static final String WINDOWS_ARGS_FILE = "win_args.txt";

    public static Process launch(File directory, String[] args) {
        ArrayList<String> launchArgs = new ArrayList<String>();
        Optional<String> javaPath = ProcessHandle.current().info().command();
        if (javaPath.isEmpty()) {
            System.err.println("No Java path found");
            System.exit(1);
        }
        launchArgs.add(javaPath.get());
        launchArgs.addAll(ManagementFactory.getRuntimeMXBean().getInputArguments());
        launchArgs.addAll(Wrapper.getForgeArgs(directory));
        launchArgs.addAll(Arrays.asList(args));
        try {
            return new ProcessBuilder(launchArgs).directory(directory).inheritIO().start();
        }
        catch (Exception e) {
            System.err.println("Failed to start forge");
            e.printStackTrace();
            System.exit(1);
            return null;
        }
    }

    protected static List<String> getForgeArgs(File searchDirectory) {
        File unixArgs;
        String[] paths = new String[]{NEOFORGE_LIBRARIES_PATH, NEOFORGE_NEW_LIBRARIES_PATH, FORGE_LIBRARIES_PATH};
        File library = Wrapper.getLibraries(searchDirectory, paths);
        if (library == null) {
            Wrapper.printMessageAndExit("Unable to find forge installation", "Please install forge using the installer");
        }
        if (!(unixArgs = new File(library, System.getProperty("os.name").toLowerCase().contains("win") ? WINDOWS_ARGS_FILE : UNIX_ARGS_FILE)).exists()) {
            File oldForgeJar = Wrapper.getOldForgeJar(searchDirectory);
            if (oldForgeJar != null) {
                return List.of("-jar", oldForgeJar.getAbsolutePath());
            }
            Wrapper.printMessageAndExit("Unable to find required forge arguments", "Please install forge using the installer");
        }
        Path relativePath = searchDirectory.toPath().relativize(unixArgs.toPath());
        return List.of("@" + relativePath);
    }

    protected static File getOldForgeJar(File searchDirectory) {
        File[] files = searchDirectory.listFiles((dir, name) -> name.matches("forge-.*\\..*-.*\\.jar"));
        if (files == null || files.length != 1) {
            return null;
        }
        return files[0];
    }

    protected static File getLibraries(File searchDirectory, String[] paths) {
        for (String path : paths) {
            File library = Wrapper.getLibrary(searchDirectory, path);
            if (library == null) continue;
            return library;
        }
        return null;
    }

    protected static File getLibrary(File searchDirectory, String path) {
        File libraries = new File(searchDirectory, path);
        if (!libraries.exists()) {
            return null;
        }
        File[] files = libraries.listFiles();
        if (files == null || files.length != 1 || !files[0].isDirectory()) {
            Wrapper.printMessageAndExit("Invalid forge installation", "There are multiple or no forge versions installed", "Delete the `libraries` directory and use the installer to install forge again");
        }
        assert (files != null);
        return files[0];
    }

    protected static void printMessageAndExit(String ... messages) {
        System.err.println(" --- ");
        for (String message : messages) {
            System.err.println(message);
        }
        System.exit(1);
    }
}

